import React, { useState } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import { ButtonWithPopup } from 'components/Roller/RollerWithPopup/ButtonWithPopup';
import IssueField from 'modules/issues/components/Issue/IssueField';
import { ExpandButton } from 'components/ExpandButton';
import { IssueFieldWithPopupProps } from './IssueFieldWithPopup.types';

export const IssueFieldWithPopup: React.FC<IssueFieldWithPopupProps> = ({
  classNames,
  fieldItem,
  name,
  pin,
  onClick,
  size,
}) => {
  const [expanded, setExpanded] = useState(false);

  return (
    <ButtonWithPopup
      button={
        <ExpandButton
          expanded={expanded}
          className={classNames?.button}
          size={size}
          text={
            <Text typography="body-long-m" weight="medium" color="primary">
              {fieldItem.text}
            </Text>
          }
          pin={pin}
        />
      }
      popupProps={{
        directions: ['bottom-center', 'bottom-right'],
        className: classNames?.popup,
      }}
      onVisibleChange={setExpanded}
    >
      <div className={classNames?.container}>
        {fieldItem.items?.map((item) => (
          <IssueField
            key={item.val}
            name={name}
            component="Button2"
            fieldProps={{
              view: 'clear',
              onClick,
              size,
            }}
            className={classNames?.child}
            {...item}
          >
            {item.text}
          </IssueField>
        ))}
      </div>
    </ButtonWithPopup>
  );
};
