import React from 'react';
import IssuePropsContext from 'modules/issues/components/Issue/IssuePropsContext';
import { TestBed } from 'components/TestBed';
import store from 'store';
import { Redux } from 'modules/issues/redux/createRedux';
import { issueStub } from './IssueHeader.stubs';
import { IssueHeader } from './IssueHeader';

export default {
  title: 'IssueHeader',
  component: IssueHeader,
};

export const Default = (args) => (
  <TestBed>
    <IssuePropsContext.Provider
      value={{
        maxAccess: 3,
        issue: issueStub,
        dispatch: store.dispatch,
        redux: {} as Redux,
      }}
    >
      <IssueHeader {...args} />
    </IssuePropsContext.Provider>
  </TestBed>
);

Default.args = {
  issue: {
    data: {
      number: 'number',
      name: 'name',
      account: {
        info: {
          name: 'account name',
        },
      },
    },
    props: {
      quickPanel: {
        access: 3,
        items: [
          {
            alert: false,
            form: 'form',
            redirect: false,
            text: 'text',
            val: 'val',
          },
        ],
      },
      actions: {
        access: 3,
        items: [
          {
            alert: false,
            form: 'form',
            redirect: false,
            text: 'text',
            val: 'val',
          },
        ],
      },
      actionStateChange: {
        access: 3,
        items: [
          {
            alert: false,
            form: 'form',
            redirect: false,
            text: 'text',
            val: 'val',
          },
        ],
      },
    },
  },
};
