import { createElement } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './Layout.modules.scss';

const Flex = props => {
  const { className: propClassName, direction, max, right, fields, ...passPropsThrough } = props;

  const className = cx(propClassName, css.Container, css[`Container_${direction}`], {
    [css.Container_max]: max,
    [css.Container_right]: right,
    [css.Container_fields]: fields,
  });

  return createElement('div', { className, ...passPropsThrough });
};

Flex.propTypes = {
  direction: PropTypes.oneOf(['row', 'column']),
};

Flex.defaultProps = {
  direction: 'row',
};

export default Flex;
