import React from 'react';
import { storiesOf } from '@storybook/react';
import { Block, ScrollMode } from '.';

const ChildComponent = ({ height, className }: { className?: string; height?: number }) => (
  <div className={className}>
    <div style={{ height, background: '#f0f0f0' }}>ChildComponent</div>
  </div>
);

const StoryBlock = ({ title, children }) => (
  <div>
    <h2>{title}</h2>
    {children}
  </div>
);

const CONTENT_HEIGHTS = [100, 300, 600];

storiesOf('LayoutBuilder/Block', module)
  .add('no scroll', () => (
    <div>
      {CONTENT_HEIGHTS.map((height) => (
        <StoryBlock key={height} title={`Height: ${height}`}>
          <Block title="Simple title">
            <ChildComponent height={height} />
          </Block>
        </StoryBlock>
      ))}
    </div>
  ))
  .add('without title', () => (
    <div>
      {CONTENT_HEIGHTS.map((height) => (
        <StoryBlock key={height} title={`Height: ${height}`}>
          <Block>
            <ChildComponent height={height} />
          </Block>
        </StoryBlock>
      ))}
    </div>
  ))
  .add('block scroll', () => (
    <div>
      {CONTENT_HEIGHTS.map((height) => (
        <StoryBlock key={height} title={`Height: ${height}`}>
          <Block title="Simple title" style={{ maxHeight: 300 }}>
            <ChildComponent height={height} />
          </Block>
        </StoryBlock>
      ))}
    </div>
  ))
  .add('content scroll', () => (
    <div>
      {CONTENT_HEIGHTS.map((height) => (
        <StoryBlock key={height} title={`Height: ${height}`}>
          <Block title="Simple title" style={{ maxHeight: 300 }} scrollMode={ScrollMode.Content}>
            {(props) => <ChildComponent className={props.className} height={height} />}
          </Block>
        </StoryBlock>
      ))}
    </div>
  ));
