import React from 'react';
import cx from 'classnames';
import css from './Block.module.css';
import { BlockProps, ScrollMode } from './Block.types';

export const Block = ({
  children,
  className,
  title,
  style,
  scrollMode = ScrollMode.Block,
}: BlockProps) => (
  <div className={cx(className, css.Block, css[`Block_scroll_${scrollMode}`])} style={style}>
    {title && <div className={css.Block__title}>{title}</div>}
    <div className={css.Block__content}>
      {typeof children === 'function' ? children({ className: css.Block__child }) : children}
    </div>
  </div>
);
