import React from 'react';
import { storiesOf } from '@storybook/react';
import { LayoutBuilder } from './LayoutBuilder';
import { Block } from './Block';

const data = {
  blocks: {
    '1': <Block>Block1</Block>,
    '2': <Block>Block2</Block>,
    '3': <Block>Block3</Block>,
    '4': <Block>Block4</Block>,
    '5': <Block>Block5</Block>,
  },
  layout: {
    schema: {
      rows: [
        {
          areaId: 'Area1',
          blockWidthRatio: 1,
          columns: [
            {
              areaId: 'Area2',
              blockWidthRatio: 1,
            },
            {
              areaId: 'Area3',
              blockWidthRatio: 2,
            },
          ],
        },
        {
          areaId: 'Area4',
          blockWidthRatio: 1,
        },
      ],
    },
    areaIdToBlocksIds: {
      Area1: ['1'],
      Area2: ['2'],
      Area3: ['3', '4'],
      Area4: ['5'],
    },
  },
};

storiesOf('LayoutBuilder', module).add('default', () => (
  <LayoutBuilder blocks={data.blocks} layout={data.layout} />
));
