import React, { FC } from 'react';
import cx from 'classnames';
import { LayoutBuilderProps, Area } from './LayoutBuilder.types';
import css from './LayoutBuilder.module.css';

export const LayoutBuilder: FC<LayoutBuilderProps> = ({ layout, blocks, className }) => {
  const renderRow = (area: Area) => {
    const { areaId, columns, blockWidthRatio } = area;

    const blocksInArea = layout.areaIdToBlocksIds[areaId];

    return (
      <div
        key={areaId}
        data-testid={areaId}
        className={css.LayoutBuilder__Area}
        style={{ flex: blockWidthRatio }}
      >
        {blocksInArea &&
          blocksInArea.map((blockId) => {
            return (
              <div key={blockId} className={css.LayoutBuilder__BlockContainer}>
                {blocks[blockId]}
              </div>
            );
          })}
        {Array.isArray(columns) && (
          <div className={css.LayoutBuilder__SubAreaContainer}>{columns.map(renderRow)}</div>
        )}
      </div>
    );
  };

  return (
    <div className={cx(className, css.LayoutBuilder, css.LayoutBuilder__Area)}>
      {layout.schema.rows.map(renderRow)}
    </div>
  );
};
