import { ReactNode } from 'react';

export interface Area {
  areaId: string;
  blockWidthRatio: number;
  columns?: Area[];
}

export interface Schema {
  rows: Area[];
}

export interface Layout {
  schema: Schema;
  areaIdToBlocksIds: Record<string, string[] | undefined>;
}

export interface LayoutBuilderProps {
  layout: Layout;
  blocks: Record<string, ReactNode>;
  className?: string;
}
