import React, { memo, FC } from 'react';
import { LayoutBuilder } from 'components/LayoutBuilder';
import { LayoutBuilderBySchemeProps } from './LayoutBuilderByScheme.types';
import { schemeBlocksToReactBlocks } from './utils/schemeBlocksToReactBlocks';

export const LayoutBuilderByScheme = memo((({ layout, blocks, className }) => {
  const reactBlocks = schemeBlocksToReactBlocks(blocks);

  return <LayoutBuilder blocks={reactBlocks} layout={layout} className={className} />;
}) as FC<LayoutBuilderBySchemeProps>);
