import React, { memo } from 'react';
import { FormBySchemeLoadable } from 'components/FormBySchemeLoadable';
import { Block, ScrollMode } from 'components/LayoutBuilder';
import { BlockProps } from '../../LayoutBuilderByScheme.types';

export const Attributes = memo(({ block }: BlockProps) => {
  const { height, title, url } = block;

  return (
    <Block title={title} scrollMode={ScrollMode.Block} style={{ height }}>
      {({ className }) => <FormBySchemeLoadable url={url} className={className} />}
    </Block>
  );
});
