import React, { memo } from 'react';
import { IFrameLoadable } from 'components/IFrameLoadable';
import { Block, ScrollMode } from 'components/LayoutBuilder';
import { BlockProps } from '../../LayoutBuilderByScheme.types';

export const IFrame = memo(({ block }: BlockProps) => {
  const { height, title, url } = block;

  return (
    <Block title={title} scrollMode={ScrollMode.Content} style={{ height }}>
      {({ className }) => <IFrameLoadable url={url} className={className} />}
    </Block>
  );
});
