import React, { memo } from 'react';
import { TableLoadable } from 'components/Table';
import { Block, ScrollMode } from 'components/LayoutBuilder';
import { BlockProps } from '../../LayoutBuilderByScheme.types';
import css from './Table.module.css';

export const Table = memo(({ block }: BlockProps) => {
  const { title, url, height } = block;

  return (
    <Block
      title={title}
      className={css.TableBlock}
      scrollMode={ScrollMode.Content}
      style={{ maxHeight: height }}
    >
      {({ className }) => <TableLoadable passUrl url={url} className={className} />}
    </Block>
  );
});
