import React, { memo } from 'react';
import { TableWithFilters as TableComponent } from 'components/Table';
import { Block, ScrollMode } from 'components/LayoutBuilder';
import { BlockProps } from '../../LayoutBuilderByScheme.types';
import css from './TableWithFilters.module.css';

export const TableWithFilters = memo(({ block }: BlockProps) => {
  const { title, url, height } = block;

  return (
    <Block
      // https://st.yandex-team.ru/CRM-14055
      //title={title}
      className={css.TableBlock}
      scrollMode={ScrollMode.Content}
      style={{ height }}
    >
      {({ className }) => <TableComponent title={title} url={url} className={className} />}
    </Block>
  );
});
