import React from 'react';
import { withIntersectionWatcher } from 'services/IntersectionWatcher/hoc/withIntersectionWatcher';
import { UnknownBlock } from '../UnknownBlock';
import { Blocks, Block } from '../LayoutBuilderByScheme.types';
import { blocks as reactBlockMap } from '../blocks';

const intersectionObservableConfig = {
  observerName: 'show_block_from_account_card',
};

export const schemeBlocksToReactBlocks = (blocks: Blocks): Record<string, React.ReactNode> => {
  const reactBlocks: Record<string, React.ReactNode> = Object.keys(blocks).reduce((ac, key) => {
    const block = blocks[key] as Block;
    const Component = reactBlockMap[block.componentType];
    const { blockType = '' } = block;
    const config = {
      ...intersectionObservableConfig,
      localMeta: { blockType },
    };
    if (Component) {
      const ComponentWithIntersectionWatcher = withIntersectionWatcher(Component, config);
      ac[key] = <ComponentWithIntersectionWatcher block={block} />;
    } else {
      ac[key] = <UnknownBlock block={block} />;
    }

    return ac;
  }, {});

  return reactBlocks;
};
