import backendTypes from 'constants/backendTypes';
import { EntityData } from './LinkModule.types';
import { ModuleName } from '../../modules/issues/types';
import createLink from '../../modules/issues/utils/createLink';

export const CONFIG = {
  [backendTypes.REQUEST]: (id) => `#/request/${id}`,
  [backendTypes.TICKET]: (id) => `#/ticket/${id}`,
  [backendTypes.CALL]: (id) => `#/phone/${id}`,
  [backendTypes.YcCALL]: (id, { parentTypeId, parentId, entityId, eType }: EntityData) =>
    `${createLink({ id: parentId, typeId: parentTypeId })}/${eType}-${entityId}`,
  [backendTypes.PERSONAL_MAIL]: (id) => `#/mail/mailId/${id}`,
  [backendTypes.MASSMAIL]: (id) => `#/massmail/${id}`,
  [backendTypes.ISSUE]: (id) => `#/issues/${id}`,
  [backendTypes.ISSUE_TICKET]: (id) => `#/${ModuleName.Ticket}/${id}`,
};
