import React from 'react';
import sp from 'utils/stopPropagation';
import Link from '@crm/components/dist/lego2/Link';
import backendTypes from 'constants/backendTypes';
import { LinkModuleType } from './LinkModule.types';
import { CONFIG } from './LinkModule.constants';

const LinkModule: LinkModuleType = (props) => {
  const { type, id, isStopPropagation, children, entityData, ...passPropsThrough } = props;

  const urlCreator = CONFIG[type];
  if (!urlCreator) {
    return <span>{children}</span>;
  }
  const href = entityData ? urlCreator(id, entityData) : urlCreator(id);
  return (
    <Link
      href={href}
      target="_blank"
      onClick={isStopPropagation ? sp : undefined}
      {...passPropsThrough}
    >
      {children}
    </Link>
  );
};

LinkModule.backendTypes = backendTypes;

export default LinkModule;
