import { FC, ReactNode } from 'react';
import { IssueType } from 'modules/issues/types';
import backendTypes from 'constants/backendTypes';

export interface EntityData {
  parentTypeId: IssueType;
  parentId: number;
  eType: 'YcCall';
  entityId: number;
}

export interface LinkModuleProps {
  type: string;
  id: number;
  isStopPropagation?: boolean;
  entityData?: EntityData;
  children: ReactNode;
}

export type LinkModuleType = FC<LinkModuleProps> & {
  backendTypes: typeof backendTypes;
};
