import React from 'react';
import { FormattedDate } from 'react-intl';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import cx from 'classnames';
import Link from '@crm/components/dist/lego2/Link';
import * as keyset from './Mail.i18n';
import css from './info.modules.scss';

const i18nRaw = createI18NRaw(keyset);
const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nFrom = commonI18n('sendFrom');
const i18nTo = commonI18n('sendTo');
const i18nACopy = commonI18n('aCopy');
const i18nBcc = createI18NRaw(commonKeyset)('bcc', { br: <br /> });
const i18nSubject = commonI18n('subject');
const i18nWillBeSent = i18n('willBeSent');
const i18nSaveAsFile = i18n('saveAsFile');
const i18nShowHeaders = i18n('showHeaders');

export default class Info extends React.Component {
  constructor(props) {
    super(props);
    this.fromContainer = React.createRef();
    this.fromNode = React.createRef();
  }

  componentDidMount() {
    // HACK forces refs to be set
    this.forceUpdate();
  }

  render() {
    const {
      id,
      className,
      theme,
      from,
      to,
      cc,
      bcc,
      subject,
      date,
      midX,
      showMeta,
      extraMeta,
      delayedDate,
      fromDecoratorFunc,
    } = this.props;
    return (
      <div className={cx(className, css.root)}>
        <div className={css.left}>
          <div className={css.row} style={{ position: 'relative' }} ref={this.fromContainer}>
            <span className={theme.label}>{i18nFrom}&nbsp;</span>
            <span style={{ position: 'relative' }} ref={this.fromNode}>
              {from}
            </span>
            {fromDecoratorFunc && fromDecoratorFunc(this.fromNode, this.fromContainer)}
          </div>
          {Boolean(to) && (
            <div className={css.row}>
              <span className={theme.label}>{i18nTo}&nbsp;</span>
              <span>{to}</span>
            </div>
          )}
          {cc ? (
            <div className={css.row}>
              <span className={theme.label}>{i18nACopy}&nbsp;</span>
              <span>{cc}</span>
            </div>
          ) : (
            ''
          )}
          {bcc ? (
            <div className={css.row}>
              <span className={theme.label}>{i18nBcc}&nbsp;</span>
              <span>{bcc}</span>
            </div>
          ) : (
            ''
          )}
          <div className={css.row}>
            <span className={theme.label}>{i18nSubject}&nbsp;</span>
            <span>{subject}</span>
          </div>
        </div>
        {showMeta && (
          <div className={css.right}>
            {delayedDate && (
              <div>
                <span className={css.delayedDate}>
                  <span className={css.delayedDate__label}>{i18nWillBeSent}</span>
                  {i18nRaw('delayedDate', {
                    day: (
                      <FormattedDate
                        value={new Date(delayedDate)}
                        year="numeric"
                        month="numeric"
                        day="numeric"
                      />
                    ),
                    time: (
                      <FormattedDate
                        value={new Date(delayedDate)}
                        hour="numeric"
                        minute="numeric"
                      />
                    ),
                  })}
                </span>
              </div>
            )}
            {date && (
              <div>
                <FormattedDate
                  value={new Date(date)}
                  year="numeric"
                  month="numeric"
                  day="numeric"
                  hour="numeric"
                  minute="numeric"
                />
              </div>
            )}
            {Boolean(midX) && (
              <div className={css.links}>
                <Link
                  key="file"
                  target="_blank"
                  title={i18nSaveAsFile}
                  href={`${global.CRM_SPACE_API_HOST}/download/mail/${id}/${id}.msg`}
                >
                  <i className="fa fa-download" />
                </Link>
                <Link
                  key="headers"
                  target="_blank"
                  title={i18nShowHeaders}
                  href={`${global.CRM_SPACE_API_HOST}/download/mail/headers/${id}`}
                >
                  <i className="fa fa-wpforms" />
                </Link>
              </div>
            )}
            {extraMeta && <div>{extraMeta}</div>}
          </div>
        )}
      </div>
    );
  }
}
