import React from 'react';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button/Button';

export default class QuoteWrapper extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      showQuote: false,
    };
  }

  handleQuoteClick = () => {
    this.setState({
      showQuote: !this.state.showQuote,
    });

    if (this.props.onQuoteClick) {
      this.props.onQuoteClick(!this.state.showQuote);
    }
  };

  render() {
    const { css, html, onQuoteClick, ...passPropsThrough } = this.props;
    return (
      <div
        {...passPropsThrough}
        data-props={JSON.stringify(this.props)}
        ref={(root) => {
          this.root = root;
        }}
      >
        <Button className={css.more} size="xs" view="pseudo" onClick={this.handleQuoteClick}>
          ...
        </Button>
        {this.state.showQuote && (
          <blockquote
            style={{ wordWrap: 'break-word' }}
            dangerouslySetInnerHTML={{ __html: html }}
          />
        )}
      </div>
    );
  }
}

QuoteWrapper.propTypes = {
  onQuoteClick: PropTypes.func,
  // eslint-disable-next-line react/forbid-prop-types
  css: PropTypes.object,
  html: PropTypes.string.isRequired,
  showQuote: PropTypes.bool,
};

QuoteWrapper.defaultProps = {
  onQuoteClick: null,
  showQuote: false,
  css: {},
};
