const LINK_TARGET_PATTERN = /(<a\s*[^>]*)(\starget="[^>^\"]*")(\s*[^>]*)(>[^<]+<\/a>)/gi;
const LINK_REL_PATTERN = /(<a\s*[^>]*)(\srel="[^>^\"]*")(\s*[^>]*)(>[^<]+<\/a>)/gi;
const LINK_PATTERN = /<a(\s*[^>]*)href="([^>^\"]*)"(\s*[^>]*)>([^<]+)<\/a>/gi;
const RESULT_FILTERED = '$1$3$4';
const RESULT_FINAL = '<a$1href="$2" rel="noopener noreferrer" target="_blank"$3>$4</a>';

const linkFormatter = (text) => {
  let formattedText = text.replace(LINK_TARGET_PATTERN, RESULT_FILTERED);

  formattedText = formattedText.replace(LINK_REL_PATTERN, RESULT_FILTERED);
  formattedText = formattedText.replace(LINK_PATTERN, RESULT_FINAL);

  return formattedText;
};

export default linkFormatter;
