const rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi;

const quotesFormatter = (html = '', elemIdPrefix = '') => {
  const resultList = [];

  const root = global.document.createElement('div');
  root.innerHTML = html.replace(rxhtmlTag, '<$1></$2>');

  let index = 0;
  const innerFunc = (element) => {
    const nodes = Array.prototype.slice.call(element.childNodes);

    nodes.forEach((node) => {
      if (node.tagName === 'BLOCKQUOTE') {
        const idStr = `mail_${elemIdPrefix}_blq_${index}`;
        index += 1;
        const divEl = global.document.createElement('div');
        divEl.id = idStr;
        node.outerHTML = divEl.outerHTML; // eslint-disable-line no-param-reassign
        const props = { html: node.innerHTML, id: idStr };

        resultList.push({ id: idStr, props });
      } else {
        innerFunc(node);
      }
    });
    return { html: element.outerHTML };
  };
  innerFunc(root);

  return { html: root.outerHTML, ids: resultList };
};

export default quotesFormatter;
