import React from 'react';
import cx from 'classnames';
import { ExpandButton } from 'components/ExpandButton';
import { ExpandHeaderProps } from './ExpandHeader.types';
import css from './ExpandHeader.module.css';
import { Label } from './Label';

export const ExpandHeader: React.FC<ExpandHeaderProps> = ({
  className,
  fields,
  expandFields,
  expandText,
  expanded,
  onExpand,
}) => {
  return (
    <div className={cx(className, css.ExpandHeader)}>
      <div className={css.ExpandHeader__info}>
        {fields?.map((field) => (
          <Label key={field.title} className={css.ExpandHeader__label} {...field} />
        ))}
        {expanded &&
          expandFields?.map((field) => (
            <Label key={field.title} className={css.ExpandHeader__label} {...field} />
          ))}
      </div>
      <div className={css.ExpandHeader__meta}>
        {expandFields && (
          <ExpandButton
            expanded={expanded}
            onClick={onExpand}
            className={css.ExpandHeader__expandButton}
            text={expandText}
            view="clear"
          />
        )}
      </div>
    </div>
  );
};
