import React from 'react';
import cx from 'classnames';
import css from './Label.module.css';
import { LabelProps } from './Label.types';

export const Label: React.FC<LabelProps> = ({ className, title, text }) => {
  return (
    <div className={cx(className, css.Label)}>
      <span className={css.Label__title}>{title}:</span>
      <span className={css.Label__text}>{text}</span>
    </div>
  );
};
