import React from 'react';
import { Attachment } from 'types/Attachment';
import image from 'components/AttachmentItem/stubs/image.png';
import { Mail2Stateful } from './Mail2Stateful';
import { Mail2Stateless } from './Mail2Stateless';

export default {
  title: 'Mail2',
};

const file: Attachment = {
  name: 'TestFile',
  id: 0,
  size: '0',
  type: 'Docviewer',
  urlName: 'TestFile.doc',
  extension: '',
  previewImageUrl: image,
};

const getFiles = (filesCount: number): Attachment[] => {
  return [...Array(filesCount)].map((_, index) => ({
    ...file,
    id: index,
    size: `${index + 10} кб`,
    name: `${file.name}_${index}`,
    previewImageUrl: index % 2 === 0 ? image : undefined,
  }));
};

export const Stateful = (args) => <Mail2Stateful {...args} />;

export const Stateless = (args) => <Mail2Stateless {...args} />;

Stateless.args = {
  id: '1',
  from: 'Ирина Исаева',
  to: 'client-service@yandex-team.ru',
  cc: 'client-service@yandex-team.ru',
  bcc: 'client-service@yandex-team.ru',
  subject: 'Списание средств',
  expandedHeader: true,
  body:
    '<div id="123"><div><div style="margin-bottom:0cm;margin-bottom:.0001pt;line-height:15.0pt;background:white;"><div><div><div>--</div><div><a href="https://yandex.ru/support/survey/?sid=B8C1A3069&amp;fid=10016151&amp;sign=B4B2948023"><span style="display:inline !important">Пожалуйста, не забудьте оценить мой ответ.</span></a></div><div>--</div><div>C уважением, Андрей</div><div>Отдел качества клиентского сервиса</div><div>&nbsp;</div><div><span style="font-size:9px"><span style="color:#696969">Настоящее сообщение и все приложения к нему предназначены только для их получателей и содержат конфиденциальную информацию и коммерческую тайну ООО «ЯНДЕКС». Их разглашение, передача третьим лицам либо иное распространение или копирование является нарушением прав ООО «ЯНДЕКС». Если вы получили настоящее сообщение по ошибке, пожалуйста, уведомите об этом отправителя и/или ООО «ЯНДЕКС» по электронной почте ответным письмом и удалите настоящее сообщение и/или всю переписку без возможности восстановления.</span></span></div></div></div></div></div></div><div>&nbsp;</div><div>&nbsp;</div><div>&nbsp;</div><div>26.05.2021, 18:10, "test-client@crm-yandex.ru" &lt;test-client@crm-yandex.ru&gt;:</div><blockquote><div>Test environment!</div></blockquote><div>&nbsp;</div><div>&nbsp;</div><blockquote><div>впвпв вапвпвапвап</div></blockquote>',
  isHtml: true,
  expandedQuoteIds: ['mail_1_BLOCKQUOTE_0'],
  files: getFiles(20),
};

Stateful.args = {
  id: '1',
  from: 'Ирина Исаева',
  to: 'client-service@yandex-team.ru',
  cc: 'client-service@yandex-team.ru',
  bcc: 'client-service@yandex-team.ru',
  subject: 'Списание средств',
  expandedHeader: true,
  body:
    '<div id="123"><div><div style="margin-bottom:0cm;margin-bottom:.0001pt;line-height:15.0pt;background:white;"><div><div><div>--</div><div><a href="https://yandex.ru/support/survey/?sid=B8C1A3069&amp;fid=10016151&amp;sign=B4B2948023"><span style="display:inline !important">Пожалуйста, не забудьте оценить мой ответ.</span></a></div><div>--</div><div>C уважением, Андрей</div><div>Отдел качества клиентского сервиса</div><div>&nbsp;</div><div><span style="font-size:9px"><span style="color:#696969">Настоящее сообщение и все приложения к нему предназначены только для их получателей и содержат конфиденциальную информацию и коммерческую тайну ООО «ЯНДЕКС». Их разглашение, передача третьим лицам либо иное распространение или копирование является нарушением прав ООО «ЯНДЕКС». Если вы получили настоящее сообщение по ошибке, пожалуйста, уведомите об этом отправителя и/или ООО «ЯНДЕКС» по электронной почте ответным письмом и удалите настоящее сообщение и/или всю переписку без возможности восстановления.</span></span></div></div></div></div></div></div><div>&nbsp;</div><div>&nbsp;</div><div>&nbsp;</div><div>26.05.2021, 18:10, "test-client@crm-yandex.ru" &lt;test-client@crm-yandex.ru&gt;:</div><blockquote><div>Test environment!</div></blockquote><div>&nbsp;</div><div>&nbsp;</div><blockquote><div>впвпв вапвпвапвап</div></blockquote>',
  isHtml: true,
  expandedQuoteIds: ['mail_1_BLOCKQUOTE_0'],
  files: getFiles(20),
};
