import React from 'react';
import cx from 'classnames';
import { ExpandHeader } from './ExpandHeader';
import { MailBodyFormatter } from './MailBodyFormatter';
import { Mail2Props } from './Mail2.types';
import css from './Mail2.module.css';

export const Mail2: React.FC<Mail2Props> = ({
  id,
  className,
  contentClassName,
  from,
  to,
  cc,
  bcc,
  subject,
  expandedHeader,
  onExpandHeader,
  body,
  isHtml,
  calendarTip,
  expandedQuoteIds,
  onQuoteClick,
  beforeContent,
}) => {
  return (
    <div className={className}>
      <ExpandHeader
        fields={[
          {
            title: 'От',
            text: from,
          },
          {
            title: 'Кому',
            text: to,
          },
        ]}
        expandFields={[
          {
            title: 'Копия',
            text: cc,
          },
          {
            title: 'Скрытая копия',
            text: bcc,
          },
          {
            title: 'Тема',
            text: subject,
          },
        ]}
        expandText={'Копия, Тема'}
        expanded={expandedHeader}
        onExpand={onExpandHeader}
      />
      {beforeContent}
      <MailBodyFormatter
        id={id}
        className={cx(css.Mail2__body, contentClassName)}
        body={body}
        isHtml={isHtml}
        calendarTip={calendarTip}
        expandedQuoteIds={expandedQuoteIds}
        onQuoteClick={onQuoteClick}
      />
    </div>
  );
};
