import { Attachment } from 'types/Attachment';
import { ReactNode } from 'react';
import { MailBodyFormatterProps } from './MailBodyFormatter';

export interface Mail2Props extends MailBodyFormatterProps {
  id: string;
  className?: string;
  contentClassName?: string;
  from?: string;
  to?: string;
  cc?: string;
  bcc?: string;
  subject?: string;
  expandedHeader?: boolean;
  onExpandHeader?: () => void;
  beforeContent?: ReactNode;
}

export interface Mail2StatelessProps extends Omit<Mail2Props, 'beforeContent'> {
  files?: Attachment[];
  isOpen: boolean;
  onHiddenItemsChange: (hiddenItemsCount: number) => void;
  hiddenFilesCount: number;
}

export interface Mail2StatefulProps
  extends Omit<Mail2Props, 'onExpandHeader' | 'expandedHeader' | 'beforeContent'> {
  files?: Attachment[];
}
