import React, { useState } from 'react';
import { AttachmentListStatefulWithFileViewer } from 'components/AttachmentList';
import { Mail2StatefulProps } from './Mail2.types';
import css from './Mail2.module.css';
import { Mail2 } from './Mail2';

export const Mail2Stateful: React.FC<Mail2StatefulProps> = ({ files, ...props }) => {
  const [isHeaderExpanded, setHeaderExpanded] = useState(false);

  const handleHeaderExpandedChange = () => {
    setHeaderExpanded((prevExpanded) => !prevExpanded);
  };

  return (
    <Mail2
      {...props}
      onExpandHeader={handleHeaderExpandedChange}
      expandedHeader={isHeaderExpanded}
      beforeContent={
        files &&
        files.length > 0 && (
          <AttachmentListStatefulWithFileViewer className={css.Mail2__files} files={files} />
        )
      }
    />
  );
};
