import React from 'react';
import { AttachmentListStatelessWithFileViewer } from 'components/AttachmentList';
import { Mail2StatelessProps } from './Mail2.types';
import css from './Mail2.module.css';
import { Mail2 } from './Mail2';

export const Mail2Stateless: React.FC<Mail2StatelessProps> = ({
  files,
  isOpen,
  hiddenFilesCount,
  onHiddenItemsChange,
  ...props
}) => {
  return (
    <Mail2
      {...props}
      beforeContent={
        files && (
          <div className={css.Mail2__files}>
            <AttachmentListStatelessWithFileViewer
              files={files}
              isOpen={isOpen}
              hiddenFilesCount={hiddenFilesCount}
              onHiddenItemsChange={onHiddenItemsChange}
            />
          </div>
        )
      }
    />
  );
};
