import React, { useLayoutEffect, useRef } from 'react';
import CalendarEvent from 'components/CalendarEvent';
import { MailBodyFormatterProps } from './MailBodyFormatter.types';
import { linkFormatter, quotesFormatter } from './MailBodyFormatter.utils';
import { QuoteWrapper } from './QuoteWrapper';

export const MailBodyFormatter: React.FC<MailBodyFormatterProps> = ({
  className,
  id,
  body,
  isHtml,
  calendarTip,
  expandedQuoteIds,
  onQuoteClick,
}) => {
  const htmlBodyRef = useRef<HTMLDivElement>(null);

  useLayoutEffect(() => {
    if (htmlBodyRef.current && isHtml && body) {
      htmlBodyRef.current.innerHTML = body;

      linkFormatter(htmlBodyRef.current);

      const clearQuotesReplacement = quotesFormatter(
        htmlBodyRef.current,
        (props) => {
          const expanded = expandedQuoteIds?.includes(props.id);
          return <QuoteWrapper {...props} expanded={expanded} onQuoteClick={onQuoteClick} />;
        },
        `mail_${id}`,
      );

      return () => {
        clearQuotesReplacement();
      };
    }
  }, [body, isHtml, expandedQuoteIds, id, onQuoteClick]);

  return (
    <div className={className}>
      <CalendarEvent event={calendarTip} />
      {isHtml ? <div ref={htmlBodyRef} /> : <pre>{body}</pre>}
    </div>
  );
};
