import { ReactElement } from 'react';
import ReactDOM from 'react-dom';
import {
  LINK_TARGET_PATTERN,
  RESULT_FILTERED,
  LINK_REL_PATTERN,
  LINK_PATTERN,
  RESULT_FINAL,
  RXHTML_TAG,
} from './MailBodyFormatter.config';
import { IdElementProps } from './MailBodyFormatter.types';

const replaceHtmlWithIdElement = (html: HTMLDivElement, tagName: string, idPrefix: string = '') => {
  const idElementPropsList: IdElementProps[] = [];

  let index = 0;
  (function replaceInner(element) {
    const nodes = Array.prototype.slice.call(element.childNodes);

    nodes.forEach((node) => {
      if (node.tagName === tagName) {
        const id = `${idPrefix}_${tagName}_${index}`;
        index += 1;
        const divEl = document.createElement('div');
        divEl.id = id;
        node.outerHTML = divEl.outerHTML; // eslint-disable-line no-param-reassign

        idElementPropsList.push({
          id,
          html: node.innerHTML,
        });
      } else {
        replaceInner(node);
      }
    });

    return { html: element.outerHTML };
  })(html);

  return idElementPropsList;
};

export const linkFormatter = (containerRef: HTMLDivElement) => {
  containerRef.innerHTML = containerRef.innerHTML
    .replace(LINK_TARGET_PATTERN, RESULT_FILTERED)
    .replace(LINK_REL_PATTERN, RESULT_FILTERED)
    .replace(LINK_PATTERN, RESULT_FINAL);
};

export const quotesFormatter = (
  containerRef: HTMLDivElement,
  element: (props: IdElementProps) => ReactElement,
  idPrefix: string = '',
) => {
  const root = document.createElement('div');
  root.innerHTML = containerRef.innerHTML.replace(RXHTML_TAG, '<$1></$2>');

  const idElementPropsList = replaceHtmlWithIdElement(root, 'BLOCKQUOTE', idPrefix);
  containerRef.innerHTML = root.outerHTML;

  idElementPropsList.forEach((idElementProps) => {
    const idElement = containerRef.querySelector(`#${idElementProps.id}`);
    if (idElement) {
      ReactDOM.render(element(idElementProps), idElement);
    }
  });

  return () => {
    idElementPropsList.forEach((idElementProps) => {
      const idElement = containerRef.querySelector(`#${idElementProps.id}`);
      if (idElement) {
        ReactDOM.unmountComponentAtNode(idElement);
      }
    });
  };
};
