import React, { useState } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { QuoteWrapperProps } from './QuoteWrapper.types';

export const QuoteWrapper: React.FC<QuoteWrapperProps> = ({
  id,
  expanded,
  html,
  onQuoteClick,
  className,
  ...passPropsThrough
}) => {
  const [isQuoteExpanded, setQuoteExpanded] = useState(expanded);

  const handleQuoteClick = () => {
    const nextQuoteExpanded = !isQuoteExpanded;
    setQuoteExpanded(nextQuoteExpanded);
    if (onQuoteClick) {
      onQuoteClick(nextQuoteExpanded, id);
    }
  };

  return (
    <div className={className} {...passPropsThrough}>
      <Button size="xs" onClick={handleQuoteClick} view="pseudo">
        ...
      </Button>
      {isQuoteExpanded && (
        <blockquote
          style={{ wordWrap: 'break-word', margin: 0, padding: '0 20px' }}
          dangerouslySetInnerHTML={{ __html: html }}
        />
      )}
    </div>
  );
};
