import { EventTarget } from 'event-target-shim';
import { DeviceMaxWidth, DeviceType } from './types';

/* todo: refactor dry */

export default class MediaMatch extends EventTarget {
  private mqlPhone = window.matchMedia(`(max-width: ${DeviceMaxWidth[DeviceType.Phone]}px)`);

  private mqlTable = window.matchMedia(
    `(min-width: ${DeviceMaxWidth[DeviceType.Phone] + 1}px) and (max-width: ${
      DeviceMaxWidth[DeviceType.Tablet]
    }px)`,
  );

  private mqlDesktop = window.matchMedia(`(min-width: ${DeviceMaxWidth[DeviceType.Tablet] + 1}px)`);

  private _deviceType: DeviceType;

  public get deviceType() {
    return this._deviceType;
  }

  public set deviceType(_deviceType: DeviceType) {
    this.dispatchEvent(new CustomEvent('change', { detail: _deviceType }));
    this._deviceType = _deviceType;
  }

  public constructor() {
    super();

    if (this.mqlPhone.matches) {
      this.deviceType = DeviceType.Phone;
    } else if (this.mqlTable.matches) {
      this.deviceType = DeviceType.Tablet;
    } else if (this.mqlDesktop.matches) {
      this.deviceType = DeviceType.Desktop;
    }

    this.mqlPhone.addListener(e => {
      if (e.matches) {
        this.deviceType = DeviceType.Phone;
      }
    });

    this.mqlTable.addListener(e => {
      if (e.matches) {
        this.deviceType = DeviceType.Tablet;
      }
    });

    this.mqlDesktop.addListener(e => {
      if (e.matches) {
        this.deviceType = DeviceType.Desktop;
      }
    });
  }
}
