import React from 'react';
import MediaMatch from './MediaMatch';
import MediaMatchContext from './MediaMatchContext';
import { DeviceType, MediaMatchEvent } from './types';

interface Props {
  children?: React.ReactNode;
}

interface State {
  deviceType: DeviceType;
}

export default class MediaMatchProvider extends React.Component<Props, State> {
  private mediaMatch: MediaMatch;

  public constructor(props) {
    super(props);

    this.mediaMatch = new MediaMatch();

    this.mediaMatch.addEventListener('change', this.handleChange);

    this.state = {
      deviceType: this.mediaMatch.deviceType,
    };
  }

  private handleChange = (e: MediaMatchEvent) => {
    if (e.detail) {
      this.setState({ deviceType: e.detail });
    }
  };

  public render() {
    const { children } = this.props;

    return (
      <MediaMatchContext.Provider value={this.state.deviceType}>
        {children}
      </MediaMatchContext.Provider>
    );
  }
}
