import { jsonApiCall } from 'api/common';

const NAME = 'Mediaplanners/';
export const UPDATE = `${NAME}UPDATE`;
export const TICKET_UPDATE = `${NAME}TICKET_UPDATE`;

export const setAttribute = ({ objectType, objectId, ...args }) => dispatch =>
  jsonApiCall({
    url: `/actions/support/${objectType}/setTimeTracking`,
    data: {
      [`${objectType}Id`]: objectId,
      ...args,
    },
  }).then(() => {
    if (objectType === 'request') {
      dispatch({ type: UPDATE, requestId: objectId, args });
    }

    if (objectType === 'ticket') {
      dispatch({ type: TICKET_UPDATE, ticketId: objectId, args });
    }
  });
