import React from 'react';
import { Attachment } from 'types/Attachment';
import image from 'components/AttachmentItem/stubs/image.png';
import { MessageStateful } from './MessageStateful';
import { MessageStateless } from './MessageStateless';

export default {
  title: 'Message',
};

const file: Attachment = {
  name: 'TestFile',
  id: 0,
  size: '0',
  type: 'Docviewer',
  urlName: 'TestFile.doc',
  extension: '',
  previewImageUrl: image,
};

const getFiles = (filesCount: number): Attachment[] => {
  return [...Array(filesCount)].map((_, index) => ({
    ...file,
    id: index,
    size: `${index + 10} кб`,
    name: `${file.name}_${index}`,
    previewImageUrl: index % 2 === 0 ? image : undefined,
  }));
};

export const Stateful = (args) => <MessageStateful {...args} />;
export const Stateless = (args) => <MessageStateless {...args} />;

Stateful.args = {
  text: 'text',
  files: getFiles(20),
};

Stateless.args = {
  text: 'text',
  files: getFiles(20),
  isOpen: false,
  onHiddenItemsChange: () => {},
  hiddenFilesCount: 0,
};
