import { Attachment } from 'types/Attachment';

export interface MessageProps {
  className?: string;
  text?: string;
  beforeContent?: React.ReactNode;
}

export interface MessageStatelessProps extends Omit<MessageProps, 'beforeContent'> {
  files?: Attachment[];
  isOpen: boolean;
  onHiddenItemsChange: (hiddenItemsCount: number) => void;
  hiddenFilesCount: number;
}

export interface MessageStatefulProps extends Omit<MessageProps, 'beforeContent'> {
  files?: Attachment[];
}
