import React from 'react';
import { AttachmentListStatefulWithFileViewer } from 'components/AttachmentList';
import { MessageStatefulProps } from './Message.types';
import css from './Message.module.css';
import { Message } from './Message';

export const MessageStateful: React.FC<MessageStatefulProps> = ({ files, ...props }) => {
  return (
    <Message
      {...props}
      beforeContent={
        files && files.length > 0 && (
          <AttachmentListStatefulWithFileViewer className={css.Message__files} files={files} />
        )
      }
    />
  );
};
