import React from 'react';
import { AttachmentListStatelessWithFileViewer } from 'components/AttachmentList';
import { MessageStatelessProps } from './Message.types';
import css from './Message.module.css';
import { Message } from './Message';

export const MessageStateless: React.FC<MessageStatelessProps> = ({
  files,
  isOpen,
  hiddenFilesCount,
  onHiddenItemsChange,
  ...props
}) => {
  return (
    <Message
      {...props}
      beforeContent={
        files && (
          <div className={css.Message__files}>
            <AttachmentListStatelessWithFileViewer
              files={files}
              isOpen={isOpen}
              hiddenFilesCount={hiddenFilesCount}
              onHiddenItemsChange={onHiddenItemsChange}
            />
          </div>
        )
      }
    />
  );
};
