import React from 'react';
import { Attachment } from 'types/Attachment';
import image from 'components/AttachmentItem/stubs/image.png';
import { MessageWithWikiFormatterStateful } from './MessageWithWikiFormatterStateful';
import { MessageWithWikiFormatterStateless } from './MessageWithWikiFormatterStateless';

export default {
  title: 'MessageWithWikiFormatter',
};

const file: Attachment = {
  name: 'TestFile',
  id: 0,
  size: '0',
  type: 'Docviewer',
  urlName: 'TestFile.doc',
  extension: '',
  previewImageUrl: image,
};

const getFiles = (filesCount: number): Attachment[] => {
  return [...Array(filesCount)].map((_, index) => ({
    ...file,
    id: index,
    size: `${index + 10} кб`,
    name: `${file.name}_${index}`,
    previewImageUrl: index % 2 === 0 ? image : undefined,
  }));
};

export const Stateful = (args) => <MessageWithWikiFormatterStateful {...args} />;
export const Stateless = (args) => <MessageWithWikiFormatterStateless {...args} />;

Stateful.args = {
  text: 'text',
  files: getFiles(20),
};

Stateless.args = {
  text: 'text',
  files: getFiles(20),
  isOpen: false,
  onHiddenItemsChange: () => {},
  hiddenFilesCount: 0,
};
