import React, { Suspense, useRef, useLayoutEffect } from 'react';
import WikiFormatter, { rootClassName } from 'components/WikiFormatter';
import { getSettings } from 'components/WikiFormatter';
import { config } from 'services/Config';
import { MessageWithWikiFormatterProps } from './MessageWithWikiFormatter.types';
import css from './MessageWithWikiFormatter.module.css';

export const MessageWithWikiFormatter: React.FC<MessageWithWikiFormatterProps> = ({
  className,
  text,
  html,
  beforeContent,
}) => {
  const htmlRef = useRef<HTMLDivElement>(null);
  const useYfm = config.value.features.useYfm;

  useLayoutEffect(() => {
    if (html && !useYfm) {
      // eslint-disable-next-line
      new Ya.FormatterViewPort({ domElem: htmlRef.current!, settings: getSettings().settings! });
    }
  }, []);

  return (
    <div className={className}>
      {beforeContent}
      {(useYfm || !html) && text && (
        <Suspense fallback={<span />}>
          <WikiFormatter className={css.MessageWithWikiFormatter__text} markdown={text} />
        </Suspense>
      )}
      {!useYfm && html && (
        <div ref={htmlRef} className={rootClassName} dangerouslySetInnerHTML={{ __html: html }} />
      )}
    </div>
  );
};