import { Attachment } from 'types/Attachment';

export interface MessageWithWikiFormatterProps {
  className?: string;
  text?: string;
  html?: string;
  beforeContent?: React.ReactNode;
}

export interface MessageWithWikiFormatterStatelessProps
  extends Omit<MessageWithWikiFormatterProps, 'beforeContent'> {
  files?: Attachment[];
  isOpen: boolean;
  onHiddenItemsChange: (hiddenItemsCount: number) => void;
  hiddenFilesCount: number;
}

export interface MessageWithWikiFormatterStatefulProps
  extends Omit<MessageWithWikiFormatterProps, 'beforeContent'> {
  files?: Attachment[];
}
