import React from 'react';
import { AttachmentListStatefulWithFileViewer } from 'components/AttachmentList';
import { MessageWithWikiFormatterStatefulProps } from './MessageWithWikiFormatter.types';
import css from './MessageWithWikiFormatter.module.css';
import { MessageWithWikiFormatter } from './MessageWithWikiFormatter';

export const MessageWithWikiFormatterStateful: React.FC<MessageWithWikiFormatterStatefulProps> = ({
  files,
  ...props
}) => {
  return (
    <MessageWithWikiFormatter
      {...props}
      beforeContent={
        files && files.length > 0 && (
            <AttachmentListStatefulWithFileViewer className={css.MessageWithWikiFormatter__files} files={files} />
        )
      }
    />
  );
};
