import React from 'react';
import { AttachmentListStatelessWithFileViewer } from 'components/AttachmentList';
import { MessageWithWikiFormatterStatelessProps } from './MessageWithWikiFormatter.types';
import css from './MessageWithWikiFormatter.module.css';
import { MessageWithWikiFormatter } from './MessageWithWikiFormatter';

export const MessageWithWikiFormatterStateless: React.FC<MessageWithWikiFormatterStatelessProps> = ({
  files,
  isOpen,
  hiddenFilesCount,
  onHiddenItemsChange,
  ...props
}) => {
  return (
    <MessageWithWikiFormatter
      {...props}
      beforeContent={
        files && (
          <div className={css.MessageWithWikiFormatter__files}>
            <AttachmentListStatelessWithFileViewer
              files={files}
              isOpen={isOpen}
              hiddenFilesCount={hiddenFilesCount}
              onHiddenItemsChange={onHiddenItemsChange}
            />
          </div>
        )
      }
    />
  );
};
