import React from 'react';
import { storiesOf } from '@storybook/react';
import Icon from '@crm/components/dist/lego2/Icon';
import ModuleIcon from './index';

const styleLightIcon = { color: 'white' };

storiesOf('ModuleIcon', module).add('ModuleIcon', () => (
  <div>
    <div style={{ padding: 20 }}>
      <span style={{ margin: 20 }}>
        <ModuleIcon icon={(cls) => <Icon className={cls} svg="mail" svgSize="xl" />} />
      </span>
      <span style={{ margin: 20 }}>
        <ModuleIcon count={10} icon={(cls) => <Icon className={cls} svg="mail" svgSize="xl" />} />
      </span>
      <span style={{ margin: 20 }}>
        <ModuleIcon
          count={100}
          subIconTop={<Icon svg="work" />}
          subIconBottom={<Icon svg="work" />}
          icon={(cls) => <Icon className={cls} svg="mail" svgSize="xl" />}
        />
      </span>
      <span style={{ margin: 20 }}>
        <ModuleIcon
          count={100}
          subIconTop={<Icon svg="work" />}
          icon={(cls) => <Icon className={cls} svg="phone" svgSize="xl" />}
        />
      </span>
    </div>
    <div style={{ padding: 20, background: '#000' }}>
      <span style={{ margin: 20 }}>
        <ModuleIcon
          icon={(cls) => <Icon style={styleLightIcon} className={cls} svg="mail" svgSize="xl" />}
        />
      </span>
      <span style={{ margin: 20 }}>
        <ModuleIcon
          count={10}
          icon={(cls) => <Icon style={styleLightIcon} className={cls} svg="mail" svgSize="xl" />}
        />
      </span>
      <span style={{ margin: 20 }}>
        <ModuleIcon
          count={100}
          subIconTop={<Icon svg="work" style={styleLightIcon} />}
          subIconBottom={<Icon svg="work" style={styleLightIcon} />}
          icon={(cls) => <Icon style={styleLightIcon} className={cls} svg="mail" svgSize="xl" />}
        />
      </span>
      <span style={{ margin: 20 }}>
        <ModuleIcon
          count={100}
          subIconTop={<Icon svg="work" style={styleLightIcon} />}
          icon={(cls) => <Icon style={styleLightIcon} className={cls} svg="phone" svgSize="xl" />}
        />
      </span>
    </div>
  </div>
));
