import * as React from 'react';
import cx from 'classnames';
import css from './ModuleIcon.module.css';

interface Props {
  className?: string;
  classNameIcon?: string;
  count?: number;
  /** @deprecated */
  children?: React.ReactNode;
  icon?: (className: string) => React.ReactNode;
  subIconTop?: React.ReactNode;
  subIconBottom?: React.ReactNode;
}

const ModuleIcon = (props: Props) => {
  const { className, classNameIcon, count = 0, children, subIconTop, subIconBottom, icon } = props;

  return (
    <span className={cx(css.b, className)}>
      <span className={classNameIcon}>
        {children}
        {icon && icon(css.b__icon)}
      </span>
      {subIconTop && <span className={cx(css.b__subIcon, css.b__subIcon_top)}>{subIconTop}</span>}
      {subIconBottom && (
        <span className={cx(css.b__subIcon, css.b__subIcon_bottom)}>{subIconBottom}</span>
      )}
      {count > 0 && <span className={css.b__balloon}>{count > 99 ? '99+' : count}</span>}
    </span>
  );
};

export default ModuleIcon;
