import React from 'react';
import cx from 'classnames';
import { useFileDragState } from 'utils/hooks/useFileDragState';
import { Dropzone } from 'components/Dropzone';
import { Overlay } from 'components/Overlay';
import { Text } from '@crm/components/dist/lego2/Text';
import { MultiOverlayDropZoneProps } from './MultiOverlayDropZone.types';
import css from './MultiOverlayDropZone.module.css';

export const MultiOverlayDropZone: React.FC<MultiOverlayDropZoneProps> = (props) => {
  const { zones, disabled } = props;
  const isDragActive = useFileDragState();

  const className = cx(props.className, css.MultiOverlayDropZone, {
    [css.MultiOverlayDropZone_hidden]: !isDragActive,
  });

  return (
    <Overlay
      display
      hidden={!isDragActive}
      hasSpinner={false}
      className={className}
      zIndex={10}
      color="rgba(255, 255, 255, 0.8)"
    >
      {zones.map((zone) => (
        <Dropzone
          key={zone.text}
          disabled={disabled}
          {...zone}
          className={cx(css.MultiOverlayDropZone__item, zone.className)}
        >
          {(isActive) => (
            <Text color={isActive ? 'primary' : 'secondary'} typography="control-m">
              {zone.text}
            </Text>
          )}
        </Dropzone>
      ))}
    </Overlay>
  );
};
