import React from 'react';
import PropTypes from 'prop-types';
import css from './styles.modules.scss';

const Name = props => {
  const { name, firstLetterClassName, ...passPropsThrough } = props;

  if (!name) {
    return null;
  }

  const firstLetter = name[0];
  const endName = name.substring(1);

  return (
    <span {...passPropsThrough}>
      <span className={firstLetterClassName}>{firstLetter}</span>
      {endName}
    </span>
  );
};

Name.propTypes = {
  name: PropTypes.string,
  firstLetterClassName: PropTypes.string,
};

Name.defaultProps = {
  name: '',
  firstLetterClassName: css.letter,
};

export default Name;
