import React, { memo, FC } from 'react';
import { FormattedTime } from 'react-intl';
import createI18N from '@yandex-int/i18n';
import cx from 'classnames';
import css from './AutoSaveDate.module.css';
import * as keyset from '../NewMailForm.i18n';

const i18nAutoSave = createI18N(keyset)('autoSave');

interface AutoSaveDateProps {
  className?: string;
  date: Date;
}

const AutoSaveDate: FC<AutoSaveDateProps> = ({ date, className }) => {
  return (
    <span className={cx(css.AutoSaveDate, className)}>
      {i18nAutoSave}&nbsp;
      <FormattedTime value={date} hour="numeric" minute="numeric" />
    </span>
  );
};

export default memo(AutoSaveDate);
