import React from 'react';
import { ImperativePopup } from '@crm/components/dist/lego2/Popup';
import Button from '@crm/components/dist/lego2/Button';
import DateTimePicker from 'lego/final-form/DateTimePicker';
import { Field } from 'react-final-form';
import Icon from 'lego/components/Icon';

interface DelayDateControlProps {
  disabled?: boolean;
}

const initOffset = { days: 1 };

class DelayDateControl extends React.Component<DelayDateControlProps> {
  private renderContent = (popupBag) => {
    return (
      <Field
        name="delayDate"
        component={DateTimePicker}
        initOnMount
        initOffset={initOffset}
        view="inline"
        minDate={new Date()}
        time
        autoFocus
        fastValues
        hasReset
        onReset={popupBag.hide}
      />
    );
  };

  private renderIcon = (iconCls): React.ReactElement => (
    <Icon className={iconCls} pack={Icon.PACKS.MATERIAL} icon="access_time" />
  );

  private renderToggle = (_, popupProps) => {
    const { disabled } = this.props;

    return (
      <Button
        className={popupProps.className}
        view="pseudo"
        disabled={disabled}
        tabIndex={-1}
        icon={this.renderIcon}
      />
    );
  };

  public render() {
    return (
      <ImperativePopup
        directions={['top-left']}
        content={this.renderContent}
        toggle={this.renderToggle}
        keepMounted={false}
        padding="xs"
      />
    );
  }
}

export default DelayDateControl;
