import React, { FC } from 'react';
import cx from 'classnames';
import css from './Footer.module.css';

interface SideProps {
  className?: string;
}

interface Footer<P = {}> extends FC<P> {
  Left: FC<SideProps>;
  Right: FC<SideProps>;
}

interface FooterProps {
  className?: string;
}

const Footer: Footer<FooterProps> = ({ children, className }) => (
  <div className={cx(className, css.Footer)}>{children}</div>
);

const Left: FC<SideProps> = ({ children, className }) => (
  <div className={cx(css.Footer__Left, className)}>{children}</div>
);

const Right: FC<SideProps> = ({ children, className }) => (
  <div className={cx(css.Footer__Right, className)}>{children}</div>
);

Footer.Left = Left;
Footer.Right = Right;

export default Footer;
